/*
 * Decompiled with CFR 0.152.
 */
package com.voxelutopia.ultramarine.world.block.entity;

import com.voxelutopia.ultramarine.data.registry.BlockEntityRegistry;
import com.voxelutopia.ultramarine.world.block.DecorativeBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class CenserBlockEntity
extends BlockEntity {
    private final int BURN_TIME = 1200;
    private int remainingTime = 0;
    private boolean lit = false;

    public CenserBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityRegistry.CENSER.get(), pos, state);
    }

    public static void tick(Level pLevel, BlockPos pPos, BlockState pState, CenserBlockEntity pBlockEntity) {
        if (pBlockEntity.remainingTime <= 0) {
            if (pBlockEntity.lit) {
                pBlockEntity.finishIncense(pLevel, pPos, pState);
            }
        } else {
            --pBlockEntity.remainingTime;
            if (pLevel.m_46467_() % 80L == 0L) {
                pLevel.m_45976_(LivingEntity.class, new AABB(pPos).m_82400_(10.0)).forEach(e -> e.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 100, 0)));
            }
        }
    }

    public void lightIncense(Level pLevel, BlockPos pPos, BlockState pState) {
        this.lit = true;
        this.remainingTime = 1200;
        pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)DecorativeBlock.LIT, (Comparable)Boolean.valueOf(true)), 3);
        this.m_6596_();
    }

    public void finishIncense(Level pLevel, BlockPos pPos, BlockState pState) {
        this.lit = false;
        this.remainingTime = 0;
        pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)DecorativeBlock.LIT, (Comparable)Boolean.valueOf(false)), 3);
        this.m_6596_();
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.remainingTime = pTag.m_128451_("BurnTime");
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        pTag.m_128405_("BurnTime", this.remainingTime);
    }
}

